<?php
if (! defined('WP_DEBUG')) {
	die( 'Direct access forbidden.' );
}
add_action( 'wp_enqueue_scripts', function () {
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
});
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5fd751439e794',
	'title' => 'Fiche produit',
	'fields' => array(
		array(
			'key' => 'field_5fd751b26086f',
			'label' => 'Nom du produit',
			'name' => 'nom_du_produit',
			'type' => 'text',
			'instructions' => 'Nom du produit, fruit ou légume à créer. Vérifier qu\'il n\'existe pas déjà.',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => 'product-name',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => 'Melon',
			'prepend' => '',
			'append' => '',
			'maxlength' => 40,
		),
		array(
			'key' => 'field_5fd7525460870',
			'label' => 'Présentation',
			'name' => 'presentation',
			'type' => 'textarea',
			'instructions' => 'Courte description du produit. Origine, famille, caractéristiques... 
600 caractères max.',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => 'presentation-produit',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => 'Le melon appartient à la famille Cucurbitaceae. Riche en eau et vitamine C. il est également doté d’une grande richesse en sucre et en provitamine A. Disponible pendant toute l’année, il est largement cultivé dans la région méditerranéenne et plus généralement dans les régions plus chaudes aux mondes.		Les principales	 variétés de Melons sont Charentais Vert, Charentais Jaune, Piel de Sapo , Galia	Canari.',
			'maxlength' => 600,
			'rows' => '',
			'new_lines' => '',
		),
		array(
			'key' => 'field_5fd757f660871',
			'label' => 'vignette',
			'name' => 'vignette',
			'type' => 'image',
			'instructions' => 'Image qui apparaitra sur l\'index des produits',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => 'thumnail-produits',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5fd7589b60872',
			'label' => 'Type de produit',
			'name' => 'type_de_produit',
			'type' => 'taxonomy',
			'instructions' => 'Fruit ou légume ?',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => 'type-produit',
				'id' => '',
			),
			'taxonomy' => 'type_de_produit',
			'field_type' => 'radio',
			'allow_null' => 0,
			'add_term' => 0,
			'save_terms' => 0,
			'load_terms' => 1,
			'return_format' => 'id',
			'multiple' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'produit',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'seamless',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'discussion',
		1 => 'comments',
		2 => 'author',
		3 => 'tags',
		4 => 'send-trackbacks',
	),
	'active' => true,
	'description' => '',
));

endif;